<?php
// Magento API credentials
$apiUrl = "https://maisonpink.me/rest/V1/products?searchCriteria[pageSize]=100";
$accessToken = "bjp8sm7ivq7crliycer45wvt9omyeop1"; // Use your actual token here

// Set header to download CSV
header('Content-Type: text/csv');
header('Content-Disposition: attachment;filename=facebook_catalog_products.csv');

// Open output stream
$output = fopen('php://output', 'w');

// Add CSV headers as per Facebook catalog requirements
fputcsv($output, ['id', 'title', 'description', 'availability', 'condition', 'price', 'link', 'image_link', 'brand']);

// Base URL for media images
$baseMediaUrl = "https://maisonpink.me/media/catalog/product";

// Initialize variables for pagination
$currentPage = 1;
$totalFetched = 0;

do {
    // Initialize cURL to fetch data
    $ch = curl_init("{$apiUrl}&searchCriteria[currentPage]={$currentPage}");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $accessToken"
    ]);

    $response = curl_exec($ch);
    curl_close($ch);

    // Convert JSON to PHP array
    $data = json_decode($response, true);

    // Check if items are present in the response
    if (!isset($data['items']) || empty($data['items'])) {
        break; // Exit loop if no items are returned
    }

    // Populate rows based on Magento fields
    foreach ($data['items'] as $item) {
        $id = $item['id'];
        $title = $item['name'] ?? '';
        $description = $item['custom_attributes']['description'] ?? ''; // Adjust if description is stored differently
        $availability = $item['status'] == 1 ? 'in stock' : 'out of stock'; // Assuming status 1 is in stock
        $condition = 'new'; // Defaulting to 'new'; change if other conditions are relevant
        $price = $item['price'] . ' USD'; // Adjust currency as needed
        $link = "https://maisonpink.me/catalog/product/view/id/{$id}"; // Customize link structure if needed

        // Retrieve the correct image link
        $image_link = '';
        if (!empty($item['media_gallery_entries'])) {
            foreach ($item['media_gallery_entries'] as $media) {
                if ($media['media_type'] === 'image') { // Ensures it's an image
                    $image_link = $media['url'] ?? $baseMediaUrl . $media['file'];
                    break; // Use the first image as the main image
                }
            }
        }
        
        $brand = $item['custom_attributes']['brand'] ?? ''; // Adjust to actual attribute code if different

        // Write row to CSV
        fputcsv($output, [$id, $title, $description, $availability, $condition, $price, $link, $image_link, $brand]);
    }

    // Update counters for pagination
    $totalFetched += count($data['items']);
    $currentPage++;

} while (count($data['items']) === 100); // Continue while 100 items are returned

fclose($output);
exit();
